/* AMX Mod X script.
*   
*	Cut The Right Wire 
*      
*	by The Specialist 
*
*        Idea : TinLab
*
*  This program is free software; you can redistribute it and/or modify it
*  under the terms of the GNU General Public License as published by the
*  Free Software Foundation; either version 2 of the License, or (at
*  your option) any later version.
*
*  This program is distributed in the hope that it will be useful, but
*  WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*  General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software Foundation,
*  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
*  In addition, as a special exception, the author gives permission to
*  link the code of this program with the Half-Life Game Engine ("HL
*  Engine") and Modified Game Libraries ("MODs") developed by Valve,
*  L.L.C ("Valve"). You must obey the GNU General Public License in all
*  respects for all of the code used other than the HL Engine and MODs
*  from Valve. If you modify this file, you may extend this exception
*  to your version of the file, but you are not obligated to do so. If
*  you do not wish to do so, delete this exception statement from your
*  version.
*/

#include <amxmodx>
#include <fakemeta>

#define TE_EXPLOSION 3

new keys = MENU_KEY_0|MENU_KEY_1|MENU_KEY_2 ;
new g_Switch;
new i;
new PlayerDefused[33];
new Sprite;
new Float:  Location[3];
new wire;
new g_AllTalk;

public plugin_init()
{
	register_plugin("Cut The Right Wire","0.4","The Specialist");
	g_Switch = register_cvar("ctrw_switch","1");
	g_AllTalk = register_cvar("ctrw_alltalk","1");
	register_dictionary("right_wire.txt");
	register_menucmd(register_menuid("menu_show"),1023,"menu_choose");
	register_event("ResetHUD","wire_call","be");
	register_logevent("bomb_defuse_no_kit", 3, "2=Begin_Bomb_Defuse_Without_Kit");
	register_logevent("bomb_defuse_no_kit", 3, "2=Begin_Bomb_Defuse_With_Kit");
	register_forward(FM_PlayerPreThink,"block_buttons");
}
// detect defusing
public bomb_defuse_no_kit()
{
	new id = get_loguser_index();
	
	if(get_pcvar_num(g_Switch)==0 || PlayerDefused[id] > 0 || is_user_bot(id)==1)
	{
		return PLUGIN_HANDLED;
	}else{
		new menu[192];
		format(menu,191,"%L",id,"CHOOSE");
		show_menu(id,keys,menu,-1,"menu_show");
		++PlayerDefused[id];
		all_talk();
		++i;
		return 0;
	}
	return 0;
}
// reset hud event 
public wire_call(id)
{
	PlayerDefused[id] = 0;
	wire = random_num(0,1);
}
// remove use button and show menu 
public menu_choose(id,key)
{
	switch(key)
	{
		case 0 :
		{
			if( wire == 0 )
			{
				--i;
				return PLUGIN_HANDLED;
			}else{
				bomb_explosion(id);
				PlayerDefused[id]  = 0;
				return 1
			}
		}
		case 1: 
		{
			if( wire == 1)
			{
				--i;
				return PLUGIN_HANDLED;
			}else{
				bomb_explosion(id);
				PlayerDefused[id] = 0;
				return 1
			}
		}
	}
	return PLUGIN_HANDLED;
}
// block the users use button
public block_buttons(id)
{
	if( i == 0 )
	{
		return 1;
	}else{
		set_pev( id, pev_button, pev(id,pev_button) & ~IN_USE);
	}
	return 1;
}
//bomb explosion 
public bomb_explosion(id)
{
	pev(id, pev_origin,Location);
	message_begin(MSG_BROADCAST,SVC_TEMPENTITY);
	write_byte(TE_EXPLOSION);
	engfunc(EngFunc_WriteCoord,Location[0]);
	engfunc(EngFunc_WriteCoord,Location[1]);
	engfunc(EngFunc_WriteCoord,Location[2]);
	write_short(Sprite);
	write_byte(255);
	write_byte(0);
	write_byte(0);
	message_end();
	user_silentkill(id);
	PlayerDefused[id] = 0;	
	i = 0;
	return 1;
}
// turn all talk on 
public all_talk()
{
	if(get_pcvar_num(g_AllTalk)==0)
	{
		return PLUGIN_HANDLED;
	}else{
		set_cvar_string("sv_alltalk","1");
	}
	return PLUGIN_HANDLED;
}
// function to get index from log events
public get_loguser_index() 
{
	new loguser[80], name[32];
	read_logargv(0, loguser, 79);
	parse_loguser(loguser, name, 31);
	return get_user_index(name);
}
//precache sprites for exloasion
public plugin_precache()
{
	Sprite = precache_model("sprites/zerogxplode.spr");
}
