/*
      Poisoned Bullets v1.3d
                    by unny;

      Random chance of poisoning an enemy / teammate when shooting him.
      Poison will increase damage dealt to the enemy!


      CVARs:
            pbullets_status                   < 0 / 1 > (default: 1)    - disable / enable plugin
            pbullets_chance                   < # >     (default: 10)   - chance of poisoning
            pbullets_dmg_multiplier           < # >     (default: 1.5)  - damage multiplier when poisoned (float)
            pbullets_poison_effect            < 0 / 1 > (default: 1)    - disable / enable poison effects
            pbullets_antidote                 < 0 / 1 > (default: 1)    - disable / enable poison antidote
            pbullets_antidote_price           < # >     (default: 9000) - price for the poison antidote
            pbullets_announce                 < 0 / 1 > (default: 1)    - print informations about the plugin


      COMMANDS:
            say / say_team buy_antidote - buy an antidote
            say / say_team use_antidote - use an antidote

      REQUIREMENTS:
            Counter-Strike 1.6 Server
            AMX Mod X 1.8.1 or higher
            HamSandwich module enabled


      CREDITS:
            BreaKer - major help
            papyrus_kn - ML (BG)
            xPaw - code improvements + ML (RU)
            crazyeffect - ML (NL)
            Letsdoit - ML (ES)
            MmikiM - ML (PL)
            tuty - blood effects idea
            xD_1991 - ML (TR)
            kanatzu - ML (SV)
            ConnorMcLeod - code improvements
            ThEGoD - ML (LT)
            Mordekay - ML (DE)


      CHANGELOG:
            v1.0  - first release
            v1.1  - multilingual (https://forums.alliedmods.net/showthread.php?t=125075)
            v1.2  - added blood effects (thx tuty!)
                  - added poison effect cvar
                  - modified the color of screen fade
                  - added status icon
            v1.3  - added poison antidote
            v1.3b - replaced Ham_TakeDamage with Ham_TraceAttack
                  - added Ham_TraceBleed
            v1.3c - fixed a bug where you could be poisoned from knife attack
            v1.3d - fixed a bug where you could buy / use antidote when you were dead
*/

#include <amxmodx>
#include <cstrike>
#include <hamsandwich>

#pragma semicolon 1

#define isPlayer(%1) (1 <= %1 <= g_iMaxPlayers)

#define MAXPLAYERS 32

#define UNIT_SECOND (1 << 12)
#define FADE_MODE 0x0000

#define DMG_BULLET (1<<1)

#define ANNOUNCE_TIME 180.0

new const VERSION[] = "1.3d";
new const TAG[] = "[ PB ]";

new g_cStatus, g_cPoisonChance, g_cPoisonedDamage, g_cPoisonEffect, g_cPoisonAntidote, g_cPoisonAntidotePrice, g_cAnnounce, g_pFriendlyFire;
new g_iMaxPlayers;
new g_msgid_ScreenFade, g_msgid_StatusIcon;
new bool:g_bPoisoned[MAXPLAYERS], bool:g_bhasAntidote[MAXPLAYERS];
new g_spr_BloodSpray, g_spr_Blood;

public plugin_init()
{
      register_plugin("Poisoned Bullets", VERSION, "unny;");
      
      register_dictionary("poisoned_bullets.txt");
      
      register_cvar("pbullets_version", VERSION, FCVAR_SERVER|FCVAR_SPONLY);
      
      g_cStatus              = register_cvar("pbullets_status", "1");
      g_cPoisonChance        = register_cvar("pbullets_chance", "10");
      g_cPoisonedDamage      = register_cvar("pbullets_dmg_multiplier", "1.5");
      g_cPoisonEffect        = register_cvar("pbullets_poison_effect", "1");
      g_cPoisonAntidote      = register_cvar("pbullets_antidote", "1");
      g_cPoisonAntidotePrice = register_cvar("pbullets_antidote_price", "9000");
      g_cAnnounce            = register_cvar("pbullets_announce", "1");
      
      g_pFriendlyFire        = get_cvar_pointer("mp_friendlyfire");
      
      RegisterHam(Ham_Spawn,       "player", "fwdSpawn");
      RegisterHam(Ham_TraceAttack, "player", "fwdTraceAttack");
      RegisterHam(Ham_Killed,      "player", "fwdKilled");
      
      g_iMaxPlayers      = get_maxplayers();
      
      g_msgid_ScreenFade = get_user_msgid("ScreenFade");
      g_msgid_StatusIcon = get_user_msgid("StatusIcon");
      
      register_clcmd("say buy_antidote", "_buyAntidote", 0, "- buy an antidote for the poisoned bullets");
      register_clcmd("say_team buy_antidote", "_buyAntidote", 0, "- buy an antidote for the poisoned bullets");
      
      register_clcmd("say use_antidote", "_useAntidote", 0, "- use the antidote for the poisoned bullets");
      register_clcmd("say_team use_antidote", "_useAntidote", 0, "- use the antidote for the poisoned bullets");
      
      set_task(ANNOUNCE_TIME, "_announce", .flags="b");
}

public plugin_precache()
{
      g_spr_BloodSpray = precache_model("sprites/bloodspray.spr");
      g_spr_Blood      = precache_model("sprites/blood.spr");
}

public _buyAntidote(id)
{
      if(!get_pcvar_num(g_cStatus) || !get_pcvar_num(g_cPoisonAntidote))
            return PLUGIN_CONTINUE;
      
      if(!is_user_alive(id))
      {
            client_print(id, print_chat, "%L", id, "DEAD", TAG);
            
            return PLUGIN_HANDLED;
      }
      
      else if(g_bhasAntidote[id])
      {
            client_print(id, print_chat, "%L", id, "ALREADY_HAVE", TAG);
            
            return PLUGIN_HANDLED;
      }
      
      else if(cs_get_user_money(id) < get_pcvar_num(g_cPoisonAntidotePrice))
      {
            client_print(id, print_chat, "%L", id, "NOT_ENOUGH_MONEY", TAG, clamp(get_pcvar_num(g_cPoisonAntidotePrice), 0, 16000));
            
            return PLUGIN_HANDLED;
      }
      
      else
      {
            client_print(id, print_chat, "%L", id, "ANTIDOTE_BOUGHT", TAG, clamp(get_pcvar_num(g_cPoisonAntidotePrice), 0, 16000));
      
            cs_set_user_money(id, cs_get_user_money(id) - get_pcvar_num(g_cPoisonAntidotePrice));
            
            g_bhasAntidote[id] = true;
            
            return PLUGIN_HANDLED;
      }
      
      return PLUGIN_CONTINUE;
}

public _useAntidote(id)
{
      if(!get_pcvar_num(g_cStatus) || !get_pcvar_num(g_cPoisonAntidote))
            return PLUGIN_CONTINUE;
            
      if(!is_user_alive(id))
      {
            client_print(id, print_chat, "%L", id, "DEAD", TAG);
            
            return PLUGIN_HANDLED;
      }
      
      else if(!g_bhasAntidote[id])
      {
            client_print(id, print_chat, "%L", id, "NO_ANTIDOTE", TAG);
            
            return PLUGIN_HANDLED;
      }
      
      else if(!g_bPoisoned[id])
      {
            client_print(id, print_chat, "%L", id, "NOT_INFECTED", TAG);
            
            return PLUGIN_HANDLED;
      }
      
      else
      {
            client_print(id, print_chat, "%L", id, "ANTIDOTE_USED", TAG);
            
            g_bhasAntidote[id] = false;
            
            g_bPoisoned[id] = false;
            
            statusIcon(id, false);
            
            screenFade(id, UNIT_SECOND, UNIT_SECOND, FADE_MODE, 0, 60, 150, 120);
            
            return PLUGIN_HANDLED;
      }
      
      return PLUGIN_CONTINUE;
}

public fwdSpawn(id)
{
      g_bPoisoned[id] = false;
      g_bhasAntidote[id] = false;
}

public fwdTraceAttack(iVictim, iAttacker, Float:fDamage, Float:fDirection[3], iTrace, iDamageBits)
{
      if(!get_pcvar_num(g_cStatus) || !isPlayer(iAttacker) || get_pcvar_num(g_cPoisonedDamage) <= 0)
            return HAM_IGNORED;
      
      if(!get_pcvar_num(g_pFriendlyFire) && get_user_team(iVictim) == get_user_team(iAttacker))
            return HAM_IGNORED;
            
      if(iDamageBits & DMG_BULLET)
      {
            new iWeapon = get_user_weapon(iAttacker);
            
            if(iWeapon == CSW_KNIFE)
                  return HAM_IGNORED;
            
            if(random_num(1, 100) <= get_pcvar_num(g_cPoisonChance))
            {                  
                  if(!g_bPoisoned[iVictim])
                  {                                        
                        new iOrigin[3];
                        get_user_origin(iVictim, iOrigin);
                        
                        if(get_pcvar_num(g_cPoisonEffect))
                        {
                              screenFade(iVictim, UNIT_SECOND, UNIT_SECOND, FADE_MODE, 0, 150, 60, 120);
                              
                              bloodEffects(iOrigin);
                              
                              statusIcon(iVictim, true);
                              
                              ExecuteHamB(Ham_TraceBleed, iVictim, fDamage, fDirection, iTrace, iDamageBits);
                        }
            
                        g_bPoisoned[iVictim] = true;
                  }
            }
      }
      
      if(g_bPoisoned[iVictim])
            SetHamParamFloat(3, fDamage * get_pcvar_float(g_cPoisonedDamage));
            
      return HAM_IGNORED;
}

public fwdKilled(iVictim, iAttacker, iShouldGib)
{
      g_bPoisoned[iVictim] = false;
      
      statusIcon(iVictim, false);
}

public client_disconnect(id)
{
      g_bPoisoned[id] = false;
      
      statusIcon(id, false);
}

public _announce()
{
      if(get_pcvar_num(g_cStatus) && get_pcvar_num(g_cAnnounce))
      {            
            client_print(0, print_chat, "%L", LANG_PLAYER, "INFO_01", TAG, VERSION);
            client_print(0, print_chat, "%L", LANG_PLAYER, "INFO_02", TAG);
            client_print(0, print_chat, "%L", LANG_PLAYER, "INFO_03", TAG);
      }
}

stock screenFade(index, bDuration, bHoldTime, bFlags, iRed, iGreen, iBlue, iAlpha)
{
      message_begin(MSG_ONE, g_msgid_ScreenFade, _, index);
      write_short(bDuration);
      write_short(bHoldTime);
      write_short(bFlags);
      write_byte(iRed);
      write_byte(iGreen);
      write_byte(iBlue);
      write_byte(iAlpha);
      message_end();
}

stock bloodEffects(iOrigin[3])
{
      message_begin(MSG_BROADCAST, SVC_TEMPENTITY, iOrigin);
      write_byte(TE_BLOODSPRITE);
      write_coord(iOrigin[0]);
      write_coord(iOrigin[1]);
      write_coord(iOrigin[2] + 5);
      write_short(g_spr_BloodSpray);
      write_short(g_spr_Blood);
      write_byte(-62);
      write_byte(10);
      message_end();
	
      message_begin(MSG_BROADCAST, SVC_TEMPENTITY, iOrigin);
      write_byte(TE_BLOODSTREAM);
      write_coord(iOrigin[0]);
      write_coord(iOrigin[1]);
      write_coord(iOrigin[2]);
      write_coord(random_num(-30, 30));
      write_coord(random_num(-30, 30));
      write_coord(random_num(50, 200));
      write_byte(-62);
      write_byte(random_num(120, 200));
      message_end();
      
      message_begin(MSG_BROADCAST, SVC_TEMPENTITY, iOrigin);
      write_byte(TE_BLOODSTREAM);
      write_coord(iOrigin[0]);
      write_coord(iOrigin[1]);
      write_coord(iOrigin[2]);
      write_coord(random_num(-360, 360));
      write_coord(random_num(-360, 360));
      write_coord(-15);
      write_byte(-62);
      write_byte(random_num(60, 120));
      message_end();      
}

stock statusIcon(iTarget, bool:bDraw) // thx Connor!
{
    message_begin(MSG_ONE, g_msgid_StatusIcon, .player=iTarget);
    write_byte(bDraw);
    write_string("dmg_poison");
    if( bDraw )
    {
        write_byte(0);
        write_byte(150);
        write_byte(60);
    }
    message_end();
}  