/* 
*  Team Flash Snitch
*
*  Author: Tender 
*  email: tender@paike.org
*  web:  www.paike.org
*  irc:  #paike @ quakenet
* 
* Description:
*  When teamflashed, this plugin announces who flashed you. The teamflasher
*  hears a "I'm blind" an gets a message of who he flashed.
*  It is also displayed for admins if someone is fully teamflashed.
*  Tested on Counter-Strike and Condition Zero servers.
*  This does NOT work for 100%...  but almost :-)
*
* Cvars:
*  
*  tfs_adminchat, default 1
*  0 - admins will not be aware
*  1 - admins gets an adminchat of who flashed who
*  
*  tfs_sound: Teamflasher hears "I'm blind!", default 1
*  0 - Sound Off
*  1 - Sound On
* 	
*  
* Changelog: 
*  1.1  - fixed bug: more than one player can get a message from the same teamflash event
*         new cvar: tfs_adminchat (2007-11-04)
*  1.0  - sound on/off cvar: tfs_sound 1/0 (2006-04-14)
*  0.3  - fixed bug: dead spectators will nog get message about teamflash (2006-03-16)
*  0.2  - changed flash owner code, a timer is added, "[Team Flash Snitch]" in green text (2006-03-12)
*  0.1  - initial release (2006-01-25)
*
* Credits:
*  Johnny got hes gun, his plugin "Blind" helped me writing this.
*  www.paike.org for testing this plugin on paike servers
*/ 

#include <amxmodx> 
#include <fakemeta> 

#define TEMPENTITY	"23"
#define BLINDED_FULLY	255
#define BLINDED_PARTLY	200 

new const TFSVERSION[] = "1.1"
new Float:FLASH_TIMER = 1.52	// Time from throwing a FB to the bang (1.52 seconds?)
new g_flasher = 0 		// id of the flasher


public plugin_init() { 
	register_plugin("Team Flash Snitch",TFSVERSION,"Tender")
	
	register_cvar("tfs_sound","1")
	register_cvar("tfs_adminchat","1")
	
	register_event("ScreenFade", "event_blinded", "be", "4=255", "5=255", "6=255", "7>199") 
	register_event(TEMPENTITY, "event_flashsmokepuff", "a", "1=5", "6=25", "7=6") 
	register_forward(FM_SetModel, "forward_setmodel") 
} 

public plugin_precache() {
	precache_sound ("radio/bot/im_blind.wav") 
	return PLUGIN_CONTINUE 
}



public event_blinded(const ID) { // someone got flashed
     
	new alpha = read_data(7) 
	if (alpha != BLINDED_FULLY && alpha != BLINDED_PARTLY || !is_user_alive(ID)) 
		return PLUGIN_CONTINUE 
	if(get_user_team(ID) == get_user_team(g_flasher) && ID != g_flasher){
		new message1[128], message2[128]
		new flasher[32], name[32] 
		get_user_name(g_flasher, flasher, 31) 
		get_user_name(ID, name, 31) 
		format(message1, 127, "^x04[Team Flash Snitch]^x01 Youve been teamflashed by %s", flasher)	
		format(message2, 127, "^x04[Team Flash Snitch]^x01 You %sflashed a teammate (%s)", alpha == BLINDED_FULLY ? "totally " : "", name)
		colored_msg(ID,message1)
		colored_msg(g_flasher,message2)
		if(get_cvar_num("tfs_sound")>0) client_cmd(g_flasher,"spk sound/radio/bot/im_blind.wav")
		if(alpha == BLINDED_FULLY && get_cvar_num("tfs_adminchat")) server_cmd("amx_chat %s flashed a teammate (%s)",flasher,name)
	}
	return PLUGIN_CONTINUE 
} 


public colored_msg(id,msg[]) { 
	message_begin(MSG_ONE, get_user_msgid("SayText"), {0,0,0}, id)
	write_byte(id)
	write_string(msg)
	message_end()
}

public event_flashsmokepuff() { // a flash has banged

	set_task(0.05,"reset_flasher") // wait until all is announced
	return PLUGIN_CONTINUE
} 

public reset_flasher(){ 
	g_flasher = 0	// clear g_flasher
}


public get_flasher(id){ // a flash is about to bang
	g_flasher = (id - 524627)
}


public forward_setmodel(const ENTITY, model[]) { // a flash is thrown
	
	if (!equal(model, "models/w_flashbang.mdl")) 
		return FMRES_IGNORED 

	new owner = pev(ENTITY, pev_owner)
	if (owner == 0) 
		return FMRES_IGNORED 

	set_task(FLASH_TIMER,"get_flasher", 524627+owner)
   
	return FMRES_IGNORED 
} 


/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1053\\ f0\\ fs16 \n\\ par }
*/
